# 导入海龟绘图库(Python 标准图形库)
import turtle
# --------------------初始化绘图环境 --------------------
# 创建绘图窗口对象
screen = turtle. Screen()
screen. title("奥运五环旗") # 设置窗口标题体现项目主题
screen. bgcolor("white") # 白色背景符合奥委会官方规范
# 创建画笔对象(控制图形绘制)
pen = turtle. Turtle()
pen. speed(5) # 设置绘制速度为中速(1 ~10 速度渐快,0 为无动画)
pen. pensize(8) # 加粗笔触至 8 像素,符合五环旗视觉标准
# --------------------绘制蓝色环(欧洲) --------------------
pen. penup() # 抬起画笔(移动时不绘制)
# 定位到蓝环起始点:X 轴 -135(左偏移),Y 轴基准点下移半径长度(60 像素)
pen. goto( -135,0 -60)
pen. pendown() # 落下画笔(开始绘制)
pen. pencolor("#0085C7") # 使用奥委会标准蓝色(Pantone Process Cyan C)
pen. circle(60) # 绘制半径 60 像素的完整圆形
# --------------------绘制红色环(美洲) --------------------
pen. penup()
# 对称定位:X 轴 +135(右偏移),Y 轴基准相同
pen. goto(135,0 -60)
pen. pendown()
pen. pencolor("#DF0024") # 标准红色(Pantone Red 032 C)
pen. circle(60)
# --------------------绘制黑色环(非洲) --------------------
pen. penup()
# 中心定位:X 轴 0(正中),Y 轴基准下移
pen. goto(0,0 -60)
pen. pendown()
pen. pencolor("#000000") # 纯黑色(Pantone Black 6 C)
pen. circle(60)
# --------------------绘制绿色环(大洋洲) --------------------
pen. penup()
# 左下定位:X 轴 -67. 5(左半距),Y 轴 -71(下移) +半径补偿
pen. goto( -67.5, -71 -60)
pen. pendown()
pen. pencolor("#009F3D") # 标准绿色(Pantone Green 356 C)
pen. circle(60)
# --------------------绘制黄色环(亚洲) --------------------
pen. penup()
# 右下对称定位:X 轴 +67. 5(右半距)
pen. goto(67.5, -71 -60)
pen. pendown()
pen. pencolor("#F4C300") # 标准黄色(Pantone Yellow 012 C)
pen. circle(60)
# --------------------添加奥运标语 --------------------
pen. penup()
# 定位到画布下方中央(Y 轴 -180 保证可见性)
pen. goto(0, -180)
pen. color("#333333") # 使用深灰色提升视觉对比度
# 书写双语标语(实际显示中文),楷体体现传统文化
pen. write("同一个世界 同一个梦想",
align = "center", # 文字居中对齐
font = ("楷体",20,"bold")) # 字体大小 20 加粗
# --------------------完成绘制 --------------------
pen. hideturtle() # 隐藏画笔图标(小海龟形状)
turtle. done() # 保持窗口开启状态(防止自动关闭)
